/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.fluid.transfer;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import io.github.fabricators_of_create.porting_lib.fluids.FluidStack;
import io.github.fabricators_of_create.porting_lib.transfer.TransferUtil;
import java.lang.reflect.Type;
import java.util.function.Consumer;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageUtil;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_2960;
import net.minecraft.class_7923;
import org.apache.commons.lang3.function.TriFunction;
import org.jetbrains.annotations.Nullable;
import slimeknights.mantle.Mantle;
import slimeknights.mantle.fluid.transfer.IFluidContainerTransfer;
import slimeknights.mantle.recipe.helper.ItemOutput;
import slimeknights.mantle.recipe.ingredient.FluidIngredient;
import slimeknights.mantle.util.JsonHelper;

public class FillFluidContainerTransfer
implements IFluidContainerTransfer {
    public static final class_2960 ID = Mantle.getResource("fill_item");
    private final class_1856 input;
    private final ItemOutput filled;
    private final FluidIngredient fluid;
    public static final JsonDeserializer<FillFluidContainerTransfer> DESERIALIZER = new Deserializer<FillFluidContainerTransfer>(FillFluidContainerTransfer::new);

    @Override
    public void addRepresentativeItems(Consumer<class_1792> consumer) {
        for (class_1799 stack : this.input.method_8105()) {
            consumer.accept(stack.method_7909());
        }
    }

    @Override
    public boolean matches(class_1799 stack, FluidStack fluid) {
        return this.input.method_8093(stack) && this.fluid.test(fluid);
    }

    protected class_1799 getFilled(FluidStack drained) {
        return this.filled.get().method_7972();
    }

    @Override
    @Nullable
    public IFluidContainerTransfer.TransferResult transfer(class_1799 stack, FluidStack fluid, Storage<FluidVariant> handler) {
        long amount = this.fluid.getAmount(fluid.getFluid());
        FluidStack toDrain = new FluidStack(fluid, amount);
        long simulated = StorageUtil.simulateInsert(handler, (Object)toDrain.getType(), (long)toDrain.getAmount(), null);
        if (simulated == amount) {
            try (Transaction t = TransferUtil.getTransaction();){
                long actual = handler.extract((Object)toDrain.getType(), toDrain.getAmount(), (TransactionContext)t);
                if (actual != amount) {
                    Mantle.logger.error("Wrong amount drained from {}, expected {}, filled {}", (Object)class_7923.field_41178.method_10221((Object)stack.method_7909()), (Object)fluid.getAmount(), (Object)actual);
                }
                t.commit();
            }
            return new IFluidContainerTransfer.TransferResult(this.getFilled(toDrain), toDrain, true);
        }
        return null;
    }

    @Override
    public JsonObject serialize(JsonSerializationContext context) {
        JsonObject json = new JsonObject();
        json.addProperty("type", ID.toString());
        json.add("input", this.input.method_8089());
        json.add("filled", this.filled.serialize());
        json.add("fluid", this.fluid.serialize());
        return json;
    }

    public FillFluidContainerTransfer(class_1856 input, ItemOutput filled, FluidIngredient fluid) {
        this.input = input;
        this.filled = filled;
        this.fluid = fluid;
    }

    public record Deserializer<T extends FillFluidContainerTransfer>(TriFunction<class_1856, ItemOutput, FluidIngredient, T> factory) implements JsonDeserializer<T>
    {
        public T deserialize(JsonElement element, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            JsonObject json = element.getAsJsonObject();
            class_1856 input = class_1856.method_52177((JsonElement)JsonHelper.getElement(json, "input"));
            ItemOutput filled = ItemOutput.fromJson(JsonHelper.getElement(json, "filled"));
            FluidIngredient fluid = FluidIngredient.deserialize(json, "fluid");
            return (T)((FillFluidContainerTransfer)this.factory.apply((Object)input, (Object)filled, (Object)fluid));
        }
    }
}

